
/** *
 *Classe che ha lo scopo di gestire il conto corrente
 */
public class ContoCorrente
{ 
    /**
      * Attributo di istanza che tiene traccia del saldo attuale
      */
    public double saldo;
    
    /**
      * Costruttore che inizializza il contocorrente con saldo pari a 0
      */
    public ContoCorrente() 
    { 
        saldo = 0;
    }

    /**
      * Costruttore che inizializza il contocorrente con un determinato saldo
      * @param    SaldoIniziale saldo iniziale del conto corrente
      */
    public ContoCorrente(double saldoIniziale)
    { 
        saldo = saldoIniziale;
    }

    /**
      * Metodo per effettuare un versamento
      * @param     somma cifra che verrà versata sul conoto corrente
      */
    public void versa(double somma)
    { 
        saldo = saldo + somma;
    }

    /**
      * Metodo per effettuare un prelievo
      * 
      * @param     somma  somma che verrà prelevata e scalata dal saldo totale
      */
    public void ritira(double somma)
    { 
        saldo = saldo - somma; 
    }

    /**
      * Metodo per effettuare l'estratto conto
      * @return    Il saldo disponibile
      */
    public double getSaldo()
    {
        return saldo;
    }
    
    /**
      * Metodo per azzerare il saldo del conto corrente
      */
    public void reset()
    {
        saldo = 0;
    }
}